#include <amxmodx>
#include <umitem>
#include <engine>
#include <fun>

new PLUGIN_NAME[] 	= "UM Item: Battle Aura"
new PLUGIN_AUTHOR[] 	= "Cheap_Suit"
new PLUGIN_VERSION[] 	= "1.1"

new bool:g_BattleAura[33]
public plugin_init() 
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	register_item("Battle Aura", "Steal enemy health", 1300)
	register_event("Damage", "Event_Damage", "be", "2!0")
}

public client_connect(id) {
	g_BattleAura[id] = false
}

public Enable_Item(id) {
	g_BattleAura[id] = true
}

public Disable_Item(id) {
	g_BattleAura[id] = false
}

public Event_Damage(id)
{
	if(!is_user_alive(id) || !is_user_connected(id)) {
		return PLUGIN_CONTINUE
	}
	
	new iDamage = read_data(2)
	new Bodypart, Weapon, Enemy = get_user_attacker(id, Weapon, Bodypart)

	if(!is_user_alive(Enemy) || !is_user_connected(Enemy)) {
		return PLUGIN_CONTINUE
	}
	
	if(Enemy == id || !g_BattleAura[Enemy]) {
		return PLUGIN_CONTINUE
	}
	
	new iHealth = get_user_health(Enemy)
	new iSteal = floatround(float(iHealth) + (float(iDamage) * 0.8))

	message_begin(MSG_ONE, get_user_msgid("ScreenFade"), { 0, 0, 0 }, Enemy)
	write_short(1<<10) 
	write_short(1<<10)
	write_short(1<<12) 
	write_byte(0)
	write_byte(255)
	write_byte(0)
	write_byte(50)
	message_end()

	if(iHealth < 100) {
		set_user_health(Enemy, iSteal)
	} else if(iHealth > 100) {
		set_user_health(Enemy, 100)
	}
	return PLUGIN_CONTINUE
}
